<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" omit-xml-declaration="yes" indent="no"></xsl:output>
	<xsl:decimal-format name="en-US" decimal-separator="." grouping-separator=","/>
	<xsl:decimal-format name="CurrencyLocal" decimal-separator="." grouping-separator=","/>
	<xsl:param name="CurrencyFormat"/>
	<xsl:param name="QuantityFormat"/>
	<xsl:param name="PercentFormat"/>
	<xsl:param name="DecimalFormatName"/>
	<xsl:key name="Dimension1Index" match="PurchaseOrder/MatrixItems/MatrixItem/ComponentItem/Dimensions" use="Dimension[1]"/>
	<xsl:key name="Dimension2Index" match="PurchaseOrder/MatrixItems/MatrixItem/ComponentItem/Dimensions" use="Dimension[2]"/>
	<xsl:key name="Dimension3Index" match="PurchaseOrder/MatrixItems/MatrixItem/ComponentItem/Dimensions" use="Dimension[3]"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>
					<xsl:value-of select="PurchaseOrder/Title"/>
				</title>
				<style type="text/css">
					body
					{
					background-color:White;
					}
					td
					{
					font-family:Arial, Verdana, Sans-Serif;
					font-size:9pt;
					}
					.Title
					{
					font-size:14pt;
					font-weight:bold;
					}
					.CompanyName
					{
					font-size:12pt;
					font-weight:bold;
					}
					.Label
					{
					vertical-align:top;
					text-align:right;
					}
					.DataDrivenLabel
					{
					text-align:left;
					}
					.ShippingLabel
					{
					vertical-align:top;
					text-align:right;
					font-weight:bold;
					}
					.ColumnHeaderRow
					{
					background-color:Silver;
					border-bottom:solid 1px black;
					}
					.ColumnHeaderCell
					{
					border-bottom:solid 1px black;
					border-right:solid 1px black;
					}
					.FooterRow
					{
					border-top:solid 1px black;
					}
					.EvenRow
					{
					background-color:#DEDFDE;
					}
					.Spacer
					{
					width:5px;
					}
					.TotalCell
					{
					text-align:right;
					font-weight:bold;
					}
					.SubTotalCell
					{
					text-align:right;
					border-right:solid 1px black;
					}
					table
					{
					width:100%;
					}
					.ListTable
					{
					border:solid 1px black;
					}
					.TableColumn
					{
					border-right:solid 1px black;
					}
					.TableColumnNumeric
					{
					border-right:solid 1px black;
					text-align:right;
					}
					.Numeric
					{
					text-align:right;
					}
				</style>
			</head>
			<body>
				<xsl:call-template name="PurchaseOrder">
					<xsl:with-param name="PO" select="PurchaseOrder"/>
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="PurchaseOrder">
		<xsl:param name="PO"/>
		<table cellpadding="0" cellspacing="0">
			<tr>
				<td rowspan="4" style="vertical-align:top">
					<img width="32" height="32" alt="Store Logo">
						<xsl:attribute name="src">
							<xsl:value-of select="$PO/StoreLogo"/>
						</xsl:attribute>
					</img>
				</td>
				<td class="CompanyName">
					<xsl:value-of select="$PO/IssuerAddress/Line[1]"/>
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="Title" colspan="3">
					<xsl:value-of select="$PO/Title"/>
				</td>
				<td valign="bottom">
					PO Number:
				</td>
				<td class="DataDrivenLabel" valign="bottom">
					<xsl:value-of select="$PO/@number"/>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:value-of select="$PO/IssuerAddress/Line[2]"/>
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td width="80">
					Requisitioner:
				</td>
				<td width="5">
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="DataDrivenLabel">
					<xsl:value-of select="$PO/Requisitioner"/>
				</td>
				<td>
					PO Date:
				</td>
				<td class="DataDrivenLabel">
					<xsl:value-of select="$PO/CreatedDate"/>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:value-of select="$PO/IssuerAddress/Line[3]"/>
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td>
					Confirming to:
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="DataDrivenLabel">
					<xsl:value-of select="$PO/ConfirmingTo"/>
				</td>
				<td>
					Req'd Date:
				</td>
				<td class="DataDrivenLabel">
					<xsl:value-of select="$PO/RequiredDate"/>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:value-of select="$PO/IssuerAddress/Line[4]"/>
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td>
					Remarks:
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td>
					<xsl:value-of select="$PO/Remarks"/>
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
			<tr>
				
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>

				<td colspan="3">
					<xsl:value-of select="$PO/IssuerAddress/Line[5]"/>
          <img src="spacer.gif" height="1" width="2"/>
					<xsl:value-of select="$PO/IssuerAddress/Line[6]"/>
				</td>
					

				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			
			</tr>


			<tr>

				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td colspan="3">
					<xsl:value-of select="$PO/IssuerAddress/Line[7]"/>
				</td>
					

				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			
			</tr>

		</table>
		<br/>
		<hr/>
		<table cellpadding="0" cellspacing="0">
			<xsl:call-template name="AddressAndFreight">
				<xsl:with-param name="PO" select="$PO"/>
			</xsl:call-template>
		</table>
		<br/>
		<xsl:if test="count($PO/Items/Item) &gt; 0">
			<table cellpadding="0" cellspacing="0" class="ListTable">
				<xsl:call-template name="Items">
					<xsl:with-param name="Items" select="$PO/Items"/>
				</xsl:call-template>
			</table>
			<br/>
		</xsl:if>
		<xsl:if test="count($PO/MatrixItems/MatrixItem) &gt; 0">
			<xsl:call-template name="MatrixItems">
				<xsl:with-param name="MatrixItems" select="$PO/MatrixItems"/>
			</xsl:call-template>
			<br/>
		</xsl:if>
		<table cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td colspan="3">
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
			<tr>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="TableColumnNumeric" style="border-right:0">
					Sub Total<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="Numeric">
					<xsl:value-of select="format-number($PO/SubTotal, $CurrencyFormat, 'CurrencyLocal')"/>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
			<tr>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="TableColumnNumeric" style="border-right:0">
					Sales Tax<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="Numeric">
					<xsl:value-of select="format-number($PO/Tax, $CurrencyFormat, 'CurrencyLocal')"/>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
			<tr>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="TableColumnNumeric" style="border-right:0">
					Shipping &amp; Handling<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="Numeric" style="text-decoration:underline">
					<xsl:value-of select="format-number($PO/Shipping, $CurrencyFormat, 'CurrencyLocal')"/>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
			<tr>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="TotalCell">
					Total<img src="spacer.gif" height="1" width="2"/>
				</td>
				<td class="Numeric" style="font-weight:bold">
					<xsl:value-of select="format-number($PO/Total, $CurrencyFormat, 'CurrencyLocal')"/>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
		</table>
		<table border="0" cellpadding="0" cellspacing="0">
		</table>
		<br/>
		<br/>
		<br/>
		<table cellpadding="0" cellspacing="0">
			<tr>
				<td colspan="2">
					<hr/>
				</td>
				<td>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
			<tr>
				<td width="30%">
					Authorized By
				</td>
				<td width="20%">
					Date
				</td>
				<td width="50%">
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
			<tr>
				<td colspan="3">
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="AddressAndFreight">
		<xsl:param name="PO"/>
		<tr>
			<td rowspan="3" style="width:3%" class="ShippingLabel">
				To:
			</td>
			<td>
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td rowspan="3" style="vertical-align:top;width:22%">
				<xsl:value-of select="$PO/To/Line[1]"/>
				<br/>
				<xsl:value-of select="$PO/To/Line[2]"/>
				<br/>
				<xsl:value-of select="$PO/To/Line[3]"/>
				<br/>
				<xsl:value-of select="$PO/To/Line[4]"/>
				<br/>
				<xsl:value-of select="$PO/To/Line[5]"/>
				<br/>
				<xsl:value-of select="$PO/To/Line[6]"/>
			</td>
			<td class="ShippingLabel" style="width:10%">
				Ship To:
			</td>
			<td>
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td rowspan="3" style="vertical-align:top;width:22%">
				<xsl:value-of select="$PO/ShipTo/Line[1]"/>
				<br/>
				<xsl:value-of select="$PO/ShipTo/Line[2]"/>
				<br/>
				<xsl:value-of select="$PO/ShipTo/Line[3]"/>
				<br/>
				<xsl:value-of select="$PO/ShipTo/Line[4]"/>
				<br/>
				<xsl:value-of select="$PO/ShipTo/Line[5]"/>
				<br/>
				<xsl:value-of select="$PO/ShipTo/Line[6]"/>
			</td>
			<tr>
				<td colspan="6">
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
		</tr>
		<tr>
			<td colspan="4">
				<img src="spacer.gif" height="1" width="2"/>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td class="Label" style="width:15%">
				Terms:
			</td>
			<td>
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td>
				<xsl:value-of select="$PO/Terms"/>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td class="Label">
				Via:
			</td>
			<td>
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td>
				<xsl:value-of select="$PO/ShipVia"/>
			</td>
			<td colspan="4">
				<img src="spacer.gif" height="1" width="2"/>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td class="Label">
          Freight:
        </td>
			<td>
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td>
				<xsl:value-of select="$PO/Freight"/>
			</td>
			<td colspan="4">
				<img src="spacer.gif" height="1" width="2"/>
			</td>
		</tr>
		<tr>
			<td colspan="3">
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td class="Label">
				F.O.B. Point:
			</td>
			<td>
				<img src="spacer.gif" height="1" width="2"/>
			</td>
			<td>
				<xsl:value-of select="$PO/FOBPoint"/>
			</td>
			<td colspan="4">
				<img src="spacer.gif" height="1" width="2"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="Items">
		<xsl:param name="Items"/>
		<tr class="ColumnHeaderRow">
			<td class="ColumnHeaderCell">
				Qty
			</td>
			<td class="ColumnHeaderCell">
				Order Number
			</td>
			<td class="ColumnHeaderCell">
				Lookup Code
			</td>
			<td class="ColumnHeaderCell">
				Description
			</td>
			<td class="ColumnHeaderCell">
				Unit Price
			</td>
			<td class="ColumnHeaderCell">
				Total
			</td>
			<td class="ColumnHeaderCell" style="border-right:none">
				Tax (%)
			</td>
		</tr>
		<xsl:choose>
			<xsl:when test="count($Items/Item) &gt; 0">
				<xsl:for-each select="$Items/Item">
					<tr>
						<xsl:choose>
							<xsl:when test="position() mod 2 = 0">
								<xsl:attribute name="class">EvenRow</xsl:attribute>
							</xsl:when>
						</xsl:choose>
						<td class="TableColumn">
							<xsl:value-of select="format-number(Quantity, $QuantityFormat, $DecimalFormatName)"/>
						</td>
						<td class="TableColumn">
							<xsl:value-of select="OrderNumber"/>
						</td>
						<td class="TableColumn">
							<xsl:value-of select="LookupCode"/>
						</td>
						<td class="TableColumn">
							<xsl:value-of select="Description"/>
						</td>
						<td class="TableColumn">
							<xsl:value-of select="format-number(UnitPrice, $CurrencyFormat, 'CurrencyLocal')"/>
						</td>
						<td class="TableColumn">
							<xsl:value-of select="format-number(TotalPrice, $CurrencyFormat, 'CurrencyLocal')"/>
						</td>
						<td class="TableColumn" style="border-right:none">
							<xsl:value-of select="format-number(TaxRate, $PercentFormat, $DecimalFormatName)"/>%
						</td>
					</tr>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<tr>
					<td colspan="7" style="text-align:center;font-weight:bold">No items.</td>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="MatrixItems">
		<xsl:param name="MatrixItems"/>
		<xsl:choose>
			<xsl:when test="count($MatrixItems/MatrixItem/ComponentItem/Dimensions/Dimension[1]/text()) = 0">
				<table cellpadding="0" cellspacing="0" class="ListTable">
					<tr>
						<td>No matrix items.</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<xsl:for-each select="$MatrixItems/MatrixItem">
					<xsl:variable name="Dimension1Unique" select="./ComponentItem/Dimensions[generate-id(.)=generate-id(key('Dimension1Index',Dimension[1])[1])]"/>
					<xsl:variable name="Dimension2Unique" select="./ComponentItem/Dimensions[generate-id(.)=generate-id(key('Dimension2Index',Dimension[2])[1])]"/>
					<xsl:variable name="Dimension3Unique" select="./ComponentItem/Dimensions[generate-id(.)=generate-id(key('Dimension3Index',Dimension[3])[1])]"/>
					<xsl:variable name="Dimension2Count" select="count(ComponentItem/Dimensions/Dimension[2]/text())"/>
					<xsl:variable name="Dimension3Count" select="count(ComponentItem/Dimensions/Dimension[3]/text())"/>
          <xsl:variable name="OrderNum" select="./OrderNumber"/>
					<table cellpadding="0" cellspacing="0">
						<tr>
							<td style="width:10%">
								Description:
							</td>
							<td style="width:24%">
								<xsl:value-of select="Description"/>
							</td>
							<td>
								<img src="spacer.gif" height="1" width="2"/>
							</td>
							<td style="width:12%">
								Lookup Code #:
							</td>
							<td style="width:16%">
								<xsl:value-of select="OrderNumber"/>
							</td>
							<td>
								<img src="spacer.gif" height="1" width="2"/>
							</td>
							<td style="width:12%">
								Tax (Amt.):
							</td>
							<td style="width:10%">
								<xsl:value-of select="format-number(TaxAmount, $CurrencyFormat, 'CurrencyLocal')"/>
							</td>
							<td>
								<img src="spacer.gif" height="1" width="2"/>
							</td>
							<td style="width:8%">
								Subtotal:
							</td>
							<td class="Numeric" style="width:8%">
								<xsl:value-of select="format-number(Total, $CurrencyFormat, 'CurrencyLocal')"/>
							</td>
						</tr>
					</table>
					<table cellpadding="0" cellspacing="0" class="ListTable">
						<tr class="ColumnHeaderRow">
							<td class="ColumnHeaderCell" style="text-align:right">
								<img src="spacer.gif" height="1" width="2"/>
							</td>
							<xsl:if test="$Dimension2Count &gt; 0">
								<td class="ColumnHeaderCell">
									<img src="spacer.gif" height="1" width="2"/>
								</td>
							</xsl:if>
							<xsl:if test="$Dimension3Count &gt; 0">
								<xsl:for-each select="$Dimension3Unique">
									<xsl:if test="string-length(Dimension[3]/text()) &gt; 0">
										<td class="ColumnHeaderCell" style="text-align:right">
											<xsl:value-of select="substring(Dimension[3]/text(),string-length($OrderNum) + 2)"/>
											<img src="spacer.gif" height="1" width="2"/>
										</td>
									</xsl:if>
								</xsl:for-each>
							</xsl:if>
							<td class="ColumnHeaderCell" style="border-right:none;text-align:right">
								Subtotal<img src="spacer.gif" height="1" width="2"/>
							</td>
						</tr>
						<xsl:choose>
							<xsl:when test="$Dimension2Count &gt; 0">
								<xsl:call-template name="ThreeDimensions">
									<xsl:with-param name="MatrixItems" select="$MatrixItems"/>
									<xsl:with-param name="Dimension1Unique" select="$Dimension1Unique"/>
									<xsl:with-param name="Dimension2Unique" select="$Dimension2Unique"/>
									<xsl:with-param name="Dimension3Unique" select="$Dimension3Unique"/>
                  <xsl:with-param name="OrderNum" select="$OrderNum"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:when test="$Dimension3Count &gt; 0">
                <xsl:call-template name="TwoDimensions">
                  <xsl:with-param name="MatrixItems" select="$MatrixItems"/>
                  <xsl:with-param name="Dimension1Unique" select="$Dimension1Unique"/>
                  <xsl:with-param name="Dimension3Unique" select="$Dimension3Unique"/>
                  <xsl:with-param name="OrderNum" select="$OrderNum"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="OneDimension">
									<xsl:with-param name="MatrixItem" select="."/>
									<xsl:with-param name="Dimension1Unique" select="$Dimension1Unique"/>
                  <xsl:with-param name="OrderNum" select="$OrderNum"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</table>
					<table cellpadding="0" cellspacing="0" border="0">
						<tr class="FooterRow" style="border-bottom:'0'">
							<td colspan="0">
								<table border="0" cellpadding="0" cellspacing="0">
									<tr>
										<td class="TotalCell" style="width:90%">
											Total Quantity<img src="spacer.gif" height="1" width="2"/>
										</td>
										<td style="font-weight:bold;width:10%" class="Numeric">
											<xsl:value-of select="format-number(Quantity, $QuantityFormat, $DecimalFormatName)"/>
											<img src="spacer.gif" height="1" width="2"/>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
					<br/>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="OneDimension">
		<xsl:param name="MatrixItem"/>
		<xsl:param name="Dimension1Unique"/>
    <xsl:param name="OrderNum"/>
		<xsl:for-each select="$Dimension1Unique">
			<xsl:variable name="Dimension1Value" select="Dimension[1]/text()"/>
			<tr>
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">
						<xsl:attribute name="class">EvenRow</xsl:attribute>
					</xsl:when>
				</xsl:choose>
				<td class="TableColumn">
					<xsl:value-of select="substring($Dimension1Value,string-length($OrderNum) + 2)"/>
				</td>
				<xsl:comment>Output the Subtotal</xsl:comment>
				<td class="TableColumnNumeric" style="border-right:none">
					<xsl:value-of select="sum($MatrixItem/ComponentItem/Dimensions[Dimension[1]=$Dimension1Value]/../Quantity)"/>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="TwoDimensions">
		<xsl:param name="MatrixItems"/>
		<xsl:param name="Dimension1Unique"/>
		<xsl:param name="Dimension3Unique"/>
    <xsl:param name="OrderNum"/>
		<xsl:for-each select="$Dimension1Unique">
			<xsl:variable name="Dimension1Value" select="Dimension[1]/text()"/>
			<tr>
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">
						<xsl:attribute name="class">EvenRow</xsl:attribute>
					</xsl:when>
				</xsl:choose>
				<td class="TableColumn">
					<xsl:value-of select="substring($Dimension1Value,string-length($OrderNum) + 2)"/>
				</td>
				<xsl:comment>Output the total quantity for each item in this dimension</xsl:comment>
				<xsl:for-each select="$Dimension3Unique">
					<xsl:if test="string-length(Dimension[3]/text()) &gt; 0">
						<xsl:variable name="Dimension3Value" select="Dimension[3]/text()"/>
						<xsl:variable name="ItemCount" select="$MatrixItems/MatrixItem/ComponentItem/Dimensions[Dimension[3]=$Dimension3Value and Dimension[1]=$Dimension1Value]/../Quantity"/>
						<td class="TableColumnNumeric">
							<xsl:choose>
								<xsl:when test="string-length($ItemCount) = 0">0</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$ItemCount"/>
								</xsl:otherwise>
							</xsl:choose>
							<img src="spacer.gif" height="1" width="2"/>
						</td>
					</xsl:if>
				</xsl:for-each>
				<xsl:comment>Output the Subtotal</xsl:comment>
				<td class="TableColumnNumeric" style="border-right:none">
					<xsl:value-of select="sum($MatrixItems/MatrixItem/ComponentItem/Dimensions[Dimension[1]=$Dimension1Value]/../Quantity)"/>
					<img src="spacer.gif" height="1" width="2"/>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="ThreeDimensions">
		<xsl:param name="MatrixItems"/>
		<xsl:param name="Dimension1Unique"/>
		<xsl:param name="Dimension2Unique"/>
		<xsl:param name="Dimension3Unique"/>
    <xsl:param name="OrderNum"/>
		<xsl:for-each select="$Dimension1Unique">
			<xsl:variable name="Dimension1Value" select="Dimension[1]/text()"/>
			<xsl:for-each select="$Dimension2Unique">
				<xsl:variable name="Dimension2Value" select="Dimension[2]/text()"/>
				<xsl:variable name="unique-row" select="$MatrixItems/MatrixItem/ComponentItem/Dimensions[Dimension[1]=$Dimension1Value and Dimension[2]=$Dimension2Value]"/>
				<xsl:if test="string-length($unique-row) &gt; 0">
					<tr>
						<td class="TableColumn">
							<xsl:value-of select="substring($Dimension1Value,string-length($OrderNum) + 2)"/>
						</td>
						<td class="TableColumn">
							<xsl:value-of select="substring($Dimension2Value,string-length($OrderNum) + 2)"/>
						</td>
						<xsl:comment>Output the total quantity for each item in this dimension</xsl:comment>
						<xsl:for-each select="$Dimension3Unique">
							<xsl:if test="string-length(Dimension[3]/text()) &gt; 0">
								<xsl:variable name="Dimension3Value" select="Dimension[3]/text()"/>
								<xsl:variable name="ItemCount" select="$MatrixItems/MatrixItem/ComponentItem/Dimensions[Dimension[1]=$Dimension1Value and Dimension[2]=$Dimension2Value and Dimension[3]=$Dimension3Value]/../Quantity"/>
								<td class="TableColumnNumeric">
									<xsl:choose>
										<xsl:when test="string-length($ItemCount) = 0">0</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$ItemCount"/>
										</xsl:otherwise>
									</xsl:choose>
									<img src="spacer.gif" height="1" width="2"/>
								</td>
							</xsl:if>
						</xsl:for-each>
						<xsl:comment>Output the Subtotal</xsl:comment>
						<td class="TableColumnNumeric" style="border-right:none">
							<xsl:value-of select="sum($MatrixItems/MatrixItem/ComponentItem/Dimensions[Dimension[1]=$Dimension1Value and Dimension[2]=$Dimension2Value]/../Quantity)"/>
							<img src="spacer.gif" height="1" width="2"/>
						</td>
					</tr>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
